package integration;

import static org.easymock.EasyMock.*;
import java.util.Arrays;
import java.util.List;
import org.springframework.test.AbstractDependencyInjectionSpringContextTests;
import client.Presenter;
import common.IDatabase;
import common.IView;

public class IntegrationTest extends
		AbstractDependencyInjectionSpringContextTests {

	protected IView view;
	protected IDatabase database;
	protected Presenter presenter;
	private List<String> searchOptions;

	public IntegrationTest() throws Exception {
		setPopulateProtectedVariables(true);
	}

	@Override
	protected String[] getConfigLocations() {
		return new String[] { "/main-context.xml",
				"/integration/test-context.xml" };
	}

	@Override
	protected void onSetUp() throws Exception {
		reset(view, database);
		view.initalizeAndDisplayView(presenter);
		expect(database.getData()).andReturn(
				new String[] { "valueA", "valueB" }).anyTimes();

		searchOptions = Arrays.asList(presenter
				.getSearchOptionSelectionStrings());
	}

	private void doFinishSetup() {
		replay(view, database);
		presenter.displayViewOnScreen();
	}

	@Override
	protected void onTearDown() throws Exception {
		verify(view, database);
	}

	public void testSearchAOnly() {
		expect(view.getSelectedSearchIndex()).andReturn(
				searchOptions.indexOf("A only"));
		view.setDisplayText("[valueA]");
		doFinishSetup();

		presenter.searchButtonPressed();
	}

	public void testSearchBOnly() {
		expect(view.getSelectedSearchIndex()).andReturn(
				searchOptions.indexOf("B only"));
		view.setDisplayText("[valueB]");
		doFinishSetup();

		presenter.searchButtonPressed();
	}

	public void testSearchAll() {
		expect(view.getSelectedSearchIndex()).andReturn(
				searchOptions.indexOf("- ALL -"));
		view.setDisplayText("[valueA, valueB]");
		doFinishSetup();

		presenter.searchButtonPressed();
	}
}
